/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.validator;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.mapping.ConstructorArgBean;
import org.brandao.brutos.mapping.ConstructorBean;
import org.brandao.brutos.mapping.NameMapping;
import org.brandao.brutos.mapping.ParameterAction;
import org.brandao.brutos.mapping.PropertyBean;
import org.brandao.brutos.mapping.PropertyController;
import org.brandao.brutos.mapping.ResultAction;
import org.brandao.brutos.validator.Validator;
import org.brandao.brutos.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR303Validator
implements Validator {
    private javax.validation.Validator objectValidator;
    private ExecutableValidator executableValidator;
    private Properties config;

    @Override
    public void configure(Properties config) {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        this.objectValidator = validatorFactory.getValidator();
        this.executableValidator = this.objectValidator.forExecutables();
        this.config = config;
    }

    @Override
    public Properties getConfiguration() {
        return this.config;
    }

    @Override
    public void validate(ConstructorArgBean source, Object value) throws ValidatorException {
    }

    @Override
    public void validate(ConstructorBean source, Object factoryInstance, Object[] value) throws ValidatorException {
        Method method = source.getMethod();
        if (method == null) {
            Set constraintViolations = this.executableValidator.validateConstructorParameters(source.getContructor(), value, new Class[0]);
            Map<String, String> map = this.getNameMap(source.getConstructorArgs());
            this.throwException(true, map, constraintViolations);
        } else {
            Set constraintViolations = this.executableValidator.validateParameters(factoryInstance, method, value, new Class[0]);
            this.throwException(true, null, constraintViolations);
        }
    }

    @Override
    public void validate(ConstructorBean source, Object factoryInstance, Object value) throws ValidatorException {
        Method method = source.getMethod();
        Set constraintViolations = method == null ? this.executableValidator.validateConstructorReturnValue(source.getContructor(), value, new Class[0]) : this.executableValidator.validateReturnValue(factoryInstance, method, value, new Class[0]);
        this.throwException(false, null, constraintViolations);
    }

    @Override
    public void validate(PropertyBean source, Object beanInstance, Object value) throws ValidatorException {
    }

    @Override
    public void validate(PropertyController source, Object controllerInstance, Object value) throws ValidatorException {
        Method method = source.getBeanProperty().getSet();
        if (method != null) {
            Set constraintViolations = this.executableValidator.validateParameters(controllerInstance, method, new Object[]{value}, new Class[0]);
            this.throwException(false, null, constraintViolations);
        }
    }

    @Override
    public void validate(ParameterAction source, Object controllerInstance, Object value) throws ValidatorException {
    }

    @Override
    public void validate(Action source, Object controller, Object[] value) throws ValidatorException {
        Method method = source.getMethod();
        if (method != null) {
            Set constraintViolations = this.executableValidator.validateParameters(controller, method, value, new Class[0]);
            Map<String, String> map = this.getNameMap(source.getParameters());
            this.throwException(true, map, constraintViolations);
        }
    }

    @Override
    @Deprecated
    public void validate(Action source, Object controller, Object value) throws ValidatorException {
    }

    @Override
    public void validate(ResultAction source, Object controller, Object value) throws ValidatorException {
        Method method = source.getAction().getMethod();
        if (method != null) {
            Set constraintViolations = this.executableValidator.validateReturnValue(controller, method, value, new Class[0]);
            this.throwException(false, null, constraintViolations);
        }
    }

    private Map<String, String> getNameMap(List<? extends NameMapping> parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        int argIndex = 0;
        for (NameMapping nameMapping : parameters) {
            if (nameMapping.getRealName().equals(nameMapping.getName())) {
                map.put("arg" + argIndex, nameMapping.getName());
            } else {
                map.put(nameMapping.getRealName(), nameMapping.getName());
            }
            ++argIndex;
        }
        return map;
    }

    protected void throwException(boolean ignoreRoot, Map<String, String> updateRoot, Set<ConstraintViolation<Object>> constraintViolations) throws ValidatorException {
        if (!constraintViolations.isEmpty()) {
            ConstraintViolation[] cvs = constraintViolations.toArray(new ConstraintViolation[0]);
            ValidatorException ex = new ValidatorException();
            for (ConstraintViolation cv : cvs) {
                Iterator iterator = cv.getPropertyPath().iterator();
                Path.Node node = (Path.Node)iterator.next();
                if (ignoreRoot) {
                    node = (Path.Node)iterator.next();
                }
                StringBuilder path = new StringBuilder();
                if (updateRoot != null) {
                    String nodeName = updateRoot.get(node.getName());
                    if (nodeName != null) {
                        path.append(nodeName);
                    } else {
                        path.append(node.getName());
                    }
                }
                while (iterator.hasNext()) {
                    node = (Path.Node)iterator.next();
                    if (node.getName() == null) continue;
                    if (path.length() != 0) {
                        path.append(".");
                    }
                    path.append(node.getName());
                }
                String strPath = path.toString();
                String message = cv.getMessage();
                ValidatorException e = new ValidatorException(message);
                ex.addCause(strPath, e);
            }
            throw ex;
        }
    }
}

