/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictionRules {
    public static final RestrictionRules MIN = new RestrictionRules("min");
    public static final RestrictionRules MINLENGTH = new RestrictionRules("minlength");
    public static final RestrictionRules MAX = new RestrictionRules("max");
    public static final RestrictionRules MAXLENGTH = new RestrictionRules("maxlength");
    public static final RestrictionRules MATCHES = new RestrictionRules("matches");
    public static final RestrictionRules REQUIRED = new RestrictionRules("required");
    public static final RestrictionRules EQUAL = new RestrictionRules("equal");
    public static final RestrictionRules CUSTOM = new RestrictionRules("custom");
    private static final Map<String, RestrictionRules> defaultRules = new HashMap<String, RestrictionRules>();
    private String name;

    public RestrictionRules(String name) {
        this.name = name;
    }

    public static List<RestrictionRules> getRestrictionRules() {
        return new ArrayList<RestrictionRules>(defaultRules.values());
    }

    public String toString() {
        return this.name;
    }

    public static RestrictionRules valueOf(String value) {
        if (defaultRules.containsKey(value)) {
            return defaultRules.get(value);
        }
        return null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestrictionRules other = (RestrictionRules)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    static {
        defaultRules.put(MIN.toString(), MIN);
        defaultRules.put(MINLENGTH.toString(), MINLENGTH);
        defaultRules.put(MAX.toString(), MAX);
        defaultRules.put(MAXLENGTH.toString(), MAXLENGTH);
        defaultRules.put(MATCHES.toString(), MATCHES);
        defaultRules.put(REQUIRED.toString(), REQUIRED);
        defaultRules.put(EQUAL.toString(), EQUAL);
        defaultRules.put(CUSTOM.toString(), CUSTOM);
    }
}

