/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.xml;

import java.util.ArrayList;
import java.util.Arrays;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.ComponentRegistry;
import org.brandao.brutos.io.Resource;
import org.brandao.brutos.mapping.StringUtil;
import org.brandao.brutos.scope.Scope;
import org.brandao.brutos.type.TypeFactory;
import org.brandao.brutos.xml.AbstractXMLDefinitionReader;
import org.brandao.brutos.xml.FilterEntity;
import org.brandao.brutos.xml.ScannerEntity;
import org.brandao.brutos.xml.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ContextDefinitionReader
extends AbstractXMLDefinitionReader {
    private final XMLParseUtil parseUtil = new XMLParseUtil("http://www.brutosframework.com.br/schema/context");
    private ScannerEntity scannerEntity;
    protected Element rootElement;

    public ContextDefinitionReader(ComponentRegistry componenetRegistry) {
        super(componenetRegistry);
    }

    public void loadDefinitions(Resource resource) {
        Element document = this.buildDocument(resource, new String[]{"classpath:brutos-context-1.1.xsd"});
        this.buildComponents(document, resource);
    }

    protected void buildComponents(Element document, Resource resource) {
        this.loadTypes(this.parseUtil.getElement(document, "types"));
        this.loadScopes(this.parseUtil.getElement(document, "extended-scopes"));
        this.loadContextParams(this.parseUtil.getElement(document, "params"));
        this.localAnnotationConfig(this.parseUtil.getElement(document, "component-scan"));
    }

    private void loadContextParams(Element cp) {
        if (cp == null) {
            return;
        }
        NodeList list = this.parseUtil.getElements(cp, "param");
        for (int i = 0; i < list.getLength(); ++i) {
            Element c = (Element)list.item(i);
            String name = this.parseUtil.getAttribute(c, "name");
            String value = this.parseUtil.getAttribute(c, "value");
            value = value == null ? c.getTextContent() : value;
            this.componentRegistry.registerProperty(name, value);
        }
    }

    private void loadTypes(Element cp) {
        if (cp == null) {
            return;
        }
        NodeList list = this.parseUtil.getElements(cp, "type");
        for (int i = 0; i < list.getLength(); ++i) {
            Element c = (Element)list.item(i);
            String value = this.parseUtil.getAttribute(c, "factory");
            value = value == null ? c.getTextContent() : value;
            try {
                Class<?> factory = ClassUtil.get(value);
                this.componentRegistry.registerType((TypeFactory)ClassUtil.getInstance(factory));
                continue;
            }
            catch (Exception e) {
                throw new BrutosException(e);
            }
        }
    }

    private void loadScopes(Element cp) {
        if (cp == null) {
            return;
        }
        NodeList list = this.parseUtil.getElements(cp, "extended-scope");
        for (int i = 0; i < list.getLength(); ++i) {
            Element c = (Element)list.item(i);
            String name = this.parseUtil.getAttribute(c, "name");
            String className = this.parseUtil.getAttribute(c, "class");
            className = className == null ? c.getTextContent() : className;
            try {
                Class<?> scope = ClassUtil.get(className);
                this.componentRegistry.registerScope(name, (Scope)ClassUtil.getInstance(scope));
                continue;
            }
            catch (Exception e) {
                throw new BrutosException(e);
            }
        }
    }

    private void localAnnotationConfig(Element element) {
        String[] stringArray;
        if (element == null) {
            return;
        }
        if (this.scannerEntity != null) {
            throw new BrutosException("scanner has been defined");
        }
        this.scannerEntity = new ScannerEntity();
        this.scannerEntity.setScannerClassName(element.getAttribute("scanner-class"));
        String basePackageText = element.getAttribute("base-package");
        if (StringUtil.isEmpty(basePackageText)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = StringUtil.getArray(basePackageText, ",");
        }
        this.scannerEntity.setBasePackage(stringArray);
        this.scannerEntity.setUseDefaultfilter("true".equals(element.getAttribute("use-default-filters")));
        NodeList list = this.parseUtil.getElements(element, "exclude-filter");
        ArrayList<FilterEntity> excludeFilters = new ArrayList<FilterEntity>();
        this.scannerEntity.setExcludeFilters(excludeFilters);
        for (int i = 0; i < list.getLength(); ++i) {
            Element filterNode = (Element)list.item(i);
            String expression = filterNode.getAttribute("expression");
            String type = filterNode.getAttribute("type");
            excludeFilters.add(new FilterEntity(type, Arrays.asList(StringUtil.getArray(expression, ","))));
        }
        list = this.parseUtil.getElements(element, "include-filter");
        ArrayList<FilterEntity> includeFilters = new ArrayList<FilterEntity>();
        this.scannerEntity.setIncludeFilters(includeFilters);
        for (int i = 0; i < list.getLength(); ++i) {
            Element filterNode = (Element)list.item(i);
            String expression = filterNode.getAttribute("expression");
            String type = filterNode.getAttribute("type");
            includeFilters.add(new FilterEntity(type, Arrays.asList(StringUtil.getArray(expression, ","))));
        }
    }

    public ScannerEntity getScannerEntity() {
        return this.scannerEntity;
    }

    public void setScannerEntity(ScannerEntity scannerEntity) {
        this.scannerEntity = scannerEntity;
    }
}

