/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.xml;

import java.util.ArrayList;
import java.util.List;
import org.brandao.brutos.ActionBuilder;
import org.brandao.brutos.ActionType;
import org.brandao.brutos.BeanBuilder;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.ComponentRegistry;
import org.brandao.brutos.ConstructorArgBuilder;
import org.brandao.brutos.ConstructorBuilder;
import org.brandao.brutos.ControllerBuilder;
import org.brandao.brutos.DataType;
import org.brandao.brutos.DispatcherType;
import org.brandao.brutos.ElementBuilder;
import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.FetchType;
import org.brandao.brutos.GenericBuilder;
import org.brandao.brutos.InterceptorBuilder;
import org.brandao.brutos.InterceptorStackBuilder;
import org.brandao.brutos.KeyBuilder;
import org.brandao.brutos.MetaBeanBuilder;
import org.brandao.brutos.ParameterBuilder;
import org.brandao.brutos.ParametersBuilder;
import org.brandao.brutos.PropertyBuilder;
import org.brandao.brutos.RestrictionBuilder;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.io.Resource;
import org.brandao.brutos.mapping.StringUtil;
import org.brandao.brutos.type.Type;
import org.brandao.brutos.validator.RestrictionRules;
import org.brandao.brutos.xml.ContextDefinitionReader;
import org.brandao.brutos.xml.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLComponentDefinitionReader
extends ContextDefinitionReader {
    protected final List<Resource> blackList;
    protected final XMLParseUtil parseUtil = new XMLParseUtil("http://www.brutosframework.com.br/schema/controllers");

    public XMLComponentDefinitionReader(ComponentRegistry componenetRegistry) {
        super(componenetRegistry);
        this.blackList = new ArrayList<Resource>();
    }

    @Override
    public void loadDefinitions(Resource resource) {
        Element document = this.buildDocument(resource, new String[]{"classpath:brutos-controllers-1.1.xsd", "classpath:brutos-context-1.1.xsd"});
        this.buildComponents(document, resource);
    }

    @Override
    protected void buildComponents(Element document, Resource resource) {
        super.buildComponents(document, resource);
        this.loadInterceptors(this.parseUtil.getElement(document, "interceptors"));
        this.loadControllers(this.parseUtil.getElement(document, "controllers"));
        this.loadControllers(this.parseUtil.getElements(document, "controller"));
        this.loadImporters(this.parseUtil.getElements(document, "import"), resource);
    }

    protected void loadImporters(NodeList list, Resource resource) {
        for (int i = 0; i < list.getLength(); ++i) {
            Element c = (Element)list.item(i);
            String dependencyName = this.parseUtil.getAttribute(c, "resource");
            if (dependencyName == null || dependencyName.length() == 0) continue;
            try {
                Resource dependencyResource = resource.getRelativeResource(dependencyName);
                if (this.blackList.contains(dependencyResource)) continue;
                this.blackList.add(dependencyResource);
                Element document = super.buildDocument(dependencyResource, new String[]{"classpath:brutos-controllers-1.1.xsd"});
                this.buildComponents(document, dependencyResource);
                continue;
            }
            catch (BrutosException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new BrutosException(ex);
            }
        }
    }

    protected void loadInterceptors(Element e) {
        if (e == null) {
            return;
        }
        NodeList list = this.parseUtil.getElements(e, "interceptor");
        this.loadInterceptor(list);
        NodeList listStack = this.parseUtil.getElements(e, "interceptor-stack");
        this.loadInterceptorStack(listStack);
    }

    protected void loadInterceptor(NodeList list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Class<?> clazz;
            Element c = (Element)list.item(i);
            String name = this.parseUtil.getAttribute(c, "name");
            String clazzName = this.parseUtil.getAttribute(c, "class");
            Boolean isDefault = Boolean.valueOf(this.parseUtil.getAttribute(c, "default"));
            try {
                clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception ex) {
                throw new BrutosException(ex);
            }
            InterceptorBuilder interceptorBuilder = this.componentRegistry.registerInterceptor(name, clazz, isDefault);
            NodeList listParam = this.parseUtil.getElements(c, "param");
            for (int k = 0; k < listParam.getLength(); ++k) {
                Element paramNode = (Element)listParam.item(k);
                String paramName = this.parseUtil.getAttribute(paramNode, "name");
                String paramValue = this.parseUtil.getAttribute(paramNode, "value");
                paramValue = paramValue == null ? paramNode.getTextContent() : paramValue;
                interceptorBuilder.addParameter(paramName, paramValue);
            }
        }
    }

    protected void loadInterceptorStack(NodeList list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Element c = (Element)list.item(i);
            String name = this.parseUtil.getAttribute(c, "name");
            Boolean isDefault = Boolean.valueOf(this.parseUtil.getAttribute(c, "default"));
            InterceptorStackBuilder interceptorStackBuilder = this.componentRegistry.registerInterceptorStack(name, isDefault);
            NodeList listInterceptorRef = this.parseUtil.getElements(c, "interceptor-ref");
            for (int j = 0; j < listInterceptorRef.getLength(); ++j) {
                Element interceptorRefNode = (Element)listInterceptorRef.item(j);
                String interceptorRefName = this.parseUtil.getAttribute(interceptorRefNode, "name");
                interceptorStackBuilder.addInterceptor(interceptorRefName);
                NodeList listParam = this.parseUtil.getElements(interceptorRefNode, "param");
                for (int k = 0; k < listParam.getLength(); ++k) {
                    Element paramNode = (Element)listParam.item(k);
                    String paramName = this.parseUtil.getAttribute(paramNode, "name");
                    String paramValue = this.parseUtil.getAttribute(paramNode, "value");
                    paramValue = paramValue == null ? paramNode.getTextContent() : paramValue;
                    interceptorStackBuilder.addParameter(interceptorRefName + "." + paramName, paramValue);
                }
            }
        }
    }

    protected void loadControllers(Element controllersNode) {
        if (controllersNode == null) {
            return;
        }
        NodeList controllers = this.parseUtil.getElements(controllersNode, "controller");
        this.loadControllers(controllers);
    }

    protected void loadControllers(NodeList controllers) {
        for (int i = 0; i < controllers.getLength(); ++i) {
            Element controllerNode = (Element)controllers.item(i);
            this.loadController(controllerNode);
        }
    }

    protected void loadController(Element controller) {
        String id = this.parseUtil.getAttribute(controller, "id");
        ActionType actionType = ActionType.valueOf(this.parseUtil.getAttribute(controller, "action-strategy"));
        DispatcherType dispatcher = DispatcherType.valueOf(this.parseUtil.getAttribute(controller, "dispatcher"));
        String view = this.parseUtil.getAttribute(controller, "view");
        boolean resolvedView = this.parseUtil.getBooleanAttribute(controller, "resolved-view");
        boolean renderedView = this.parseUtil.getBooleanAttribute(controller, "rendered-view");
        String name = this.parseUtil.getAttribute(controller, "name");
        String clazzName = this.parseUtil.getAttribute(controller, "class");
        String actionId = this.parseUtil.getAttribute(controller, "action-id");
        String defaultAction = this.parseUtil.getAttribute(controller, "default-action");
        Class<?> clazz = this.getClass(clazzName);
        ControllerBuilder controllerBuilder = this.componentRegistry.registerController(id, renderedView ? view : null, dispatcher, renderedView ? resolvedView : true, name, clazz, actionId, actionType);
        if (defaultAction != null) {
            controllerBuilder.setDefaultAction(defaultAction);
        }
        this.loadControllerDependencies(controller, controllerBuilder);
    }

    protected void loadControllerDependencies(Element controller, ControllerBuilder controllerBuilder) {
        this.loadAliasController(this.parseUtil.getElements(controller, "alias"), controllerBuilder);
        this.addInterceptorController(this.parseUtil.getElements(controller, "interceptor-ref"), controllerBuilder);
        this.addBeans(this.parseUtil.getElements(controller, "bean"), controllerBuilder);
        this.addProperties(this.parseUtil.getElements(controller, "property"), controllerBuilder);
        this.addActions(this.parseUtil.getElements(controller, "action"), controllerBuilder);
        this.loadAcceptRequestTypes(this.parseUtil.getElements(controller, "accept-request-type"), controllerBuilder);
        this.loadResponseTypes(this.parseUtil.getElements(controller, "response-type"), controllerBuilder);
        this.addThrowSafe(this.parseUtil.getElements(controller, "throw-safe"), controllerBuilder);
    }

    protected void loadAliasController(NodeList aliasNode, ControllerBuilder controllerBuilder) {
        for (int i = 0; i < aliasNode.getLength(); ++i) {
            Element c = (Element)aliasNode.item(i);
            controllerBuilder.addAlias(c.getTextContent());
        }
    }

    protected void addInterceptorController(NodeList interceptorList, ControllerBuilder controllerBuilder) {
        for (int j = 0; j < interceptorList.getLength(); ++j) {
            Element interceptorRefNode = (Element)interceptorList.item(j);
            String interceptorRefName = this.parseUtil.getAttribute(interceptorRefNode, "name");
            InterceptorBuilder interceptorBuilder = controllerBuilder.addInterceptor(interceptorRefName);
            NodeList listParam = this.parseUtil.getElements(interceptorRefNode, "param");
            for (int k = 0; k < listParam.getLength(); ++k) {
                Element paramNode = (Element)listParam.item(k);
                String paramName = this.parseUtil.getAttribute(paramNode, "name");
                String paramValue = this.parseUtil.getAttribute(paramNode, "value");
                paramValue = paramValue == null ? paramNode.getTextContent() : paramValue;
                interceptorBuilder.addParameter(paramName, paramValue);
            }
        }
    }

    protected void addBeans(NodeList beanList, ControllerBuilder controllerBuilder) {
        for (int k = 0; k < beanList.getLength(); ++k) {
            Element beanNode = (Element)beanList.item(k);
            this.addBean(beanNode, controllerBuilder, null);
        }
    }

    protected void addBean(Element beanNode, ControllerBuilder controllerBuilder, String propertyName) {
        String name = this.parseUtil.getAttribute(beanNode, "name");
        String separator = this.parseUtil.getAttribute(beanNode, "separator");
        String indexFormat = this.parseUtil.getAttribute(beanNode, "index-format");
        String factory = this.parseUtil.getAttribute(beanNode, "factory");
        String methodFactory = this.parseUtil.getAttribute(beanNode, "method-factory");
        String target = this.parseUtil.getAttribute(beanNode, "target");
        Class<?> clazz = null;
        try {
            clazz = Class.forName(target, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        BeanBuilder beanBuilder = propertyName != null ? controllerBuilder.buildProperty(propertyName, clazz) : controllerBuilder.buildMappingBean(name, clazz);
        beanBuilder.setFactory(factory);
        beanBuilder.setMethodfactory(methodFactory);
        beanBuilder.setSeparator(separator);
        beanBuilder.setIndexFormat(indexFormat);
        this.buildBean(beanNode, beanBuilder);
    }

    protected void addBean(Element beanNode, BeanBuilder bean, ConstructorBuilder constructorBuilder, String name, String propertyName, boolean key, String keyName, boolean element, String elementName) {
        String separator = this.parseUtil.getAttribute(beanNode, "separator");
        String indexFormat = this.parseUtil.getAttribute(beanNode, "index-format");
        int maxItens = this.parseUtil.getIntAttribute(beanNode, "max-itens");
        String factory = this.parseUtil.getAttribute(beanNode, "factory");
        String methodFactory = this.parseUtil.getAttribute(beanNode, "method-factory");
        String target = this.parseUtil.getAttribute(beanNode, "target");
        Class<?> clazz = null;
        try {
            clazz = Class.forName(target, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        BeanBuilder beanBuilder = key ? bean.buildKey(keyName, clazz) : (element ? bean.buildElement(elementName, clazz) : (constructorBuilder != null ? constructorBuilder.buildConstructorArg(name, clazz) : bean.buildProperty(name, propertyName, clazz)));
        beanBuilder.setFactory(factory);
        beanBuilder.setMethodfactory(methodFactory);
        beanBuilder.setSeparator(separator);
        beanBuilder.setIndexFormat(indexFormat);
        if (maxItens >= 0) {
            beanBuilder.setMaxItens(maxItens);
        }
        this.buildBean(beanNode, beanBuilder);
    }

    protected void addBean(String name, Element beanNode, ParametersBuilder parametersBuilder, Class<?> paramType) {
        String separator = this.parseUtil.getAttribute(beanNode, "separator");
        int maxItens = this.parseUtil.getIntAttribute(beanNode, "max-itens");
        String indexFormat = this.parseUtil.getAttribute(beanNode, "index-format");
        String factory = this.parseUtil.getAttribute(beanNode, "factory");
        String methodFactory = this.parseUtil.getAttribute(beanNode, "method-factory");
        String target = this.parseUtil.getAttribute(beanNode, "target");
        Class<?> clazz = null;
        try {
            clazz = ClassUtil.get(target);
        }
        catch (Throwable ex) {
            throw new BrutosException(ex);
        }
        BeanBuilder beanBuilder = parametersBuilder.buildParameter(name, paramType, clazz);
        beanBuilder.setFactory(factory);
        beanBuilder.setMethodfactory(methodFactory);
        beanBuilder.setSeparator(separator);
        beanBuilder.setIndexFormat(indexFormat);
        if (maxItens >= 0) {
            beanBuilder.setMaxItens(maxItens);
        }
        this.buildBean(beanNode, beanBuilder);
    }

    protected void buildBean(Element beanNode, BeanBuilder beanBuilder) {
        Element elementNode;
        this.buildConstructorBean(this.parseUtil.getElements(beanNode, "constructor-arg"), beanBuilder);
        this.buildPropertiesBean(this.parseUtil.getElements(beanNode, "property"), beanBuilder);
        Element keyNode = this.parseUtil.getElement(beanNode, "key");
        if (keyNode != null) {
            this.buildKeyCollection(keyNode, beanBuilder);
        }
        if ((elementNode = this.parseUtil.getElement(beanNode, "element")) != null) {
            this.buildElementCollection(elementNode, beanBuilder);
        }
    }

    protected void buildAny(Element anyNode, GenericBuilder builder) {
        String enumPropertyName = this.parseUtil.getAttribute(anyNode, "enum-property");
        EnumerationType enumProperty = EnumerationType.valueOf(enumPropertyName);
        String temporalProperty = this.parseUtil.getAttribute(anyNode, "temporal-property");
        String bean = this.parseUtil.getAttribute(anyNode, "bean");
        String scopeName = this.parseUtil.getAttribute(anyNode, "scope");
        ScopeType scope = ScopeType.valueOf(scopeName);
        String factoryName = this.parseUtil.getAttribute(anyNode, "type-def");
        String typeName = this.parseUtil.getAttribute(anyNode, "type");
        Type factory = null;
        Class<?> type = null;
        try {
            if (factoryName != null) {
                factory = (Type)ClassUtil.getInstance(ClassUtil.get(factoryName));
            }
            if (typeName != null) {
                type = ClassUtil.get(typeName);
            }
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        MetaBeanBuilder metaBeanBuilder = builder.buildMetaBean(bean, scope, enumProperty, temporalProperty, type, factory);
        NodeList metaValueList = this.parseUtil.getElements(anyNode, "meta-value");
        for (int i = 0; i < metaValueList.getLength(); ++i) {
            Element metaValue = (Element)metaValueList.item(i);
            this.buildMetaBean(metaValue, metaBeanBuilder);
        }
    }

    protected void buildMetaBean(Element metaValue, MetaBeanBuilder metaBeanBuilder) {
        String bean = this.parseUtil.getAttribute(metaValue, "bean");
        String value = this.parseUtil.getAttribute(metaValue, "value");
        Element mappingRef = this.parseUtil.getElement(metaValue, "ref");
        Element beanNode = this.parseUtil.getElement(metaValue, "bean");
        if (mappingRef != null) {
            bean = this.parseUtil.getAttribute(mappingRef, "bean");
            String enumPropertyName = this.parseUtil.getAttribute(mappingRef, "enum-property");
            EnumerationType enumProperty = EnumerationType.valueOf(enumPropertyName);
            String temporalProperty = this.parseUtil.getAttribute(mappingRef, "temporal-property");
            String scopeName = this.parseUtil.getAttribute(mappingRef, "scope");
            ScopeType scope = ScopeType.valueOf(scopeName);
            String factoryName = this.parseUtil.getAttribute(mappingRef, "type-def");
            String typeName = this.parseUtil.getAttribute(mappingRef, "type");
            Type factory = null;
            Class<?> type = null;
            try {
                if (factoryName != null) {
                    factory = (Type)ClassUtil.getInstance(ClassUtil.get(factoryName));
                }
                if (typeName != null) {
                    type = ClassUtil.get(typeName);
                }
            }
            catch (Exception ex) {
                throw new BrutosException(ex);
            }
            metaBeanBuilder.addMetaValue(value, enumProperty, temporalProperty, null, scope, factory, type);
        } else if (beanNode != null) {
            this.addBean(value, beanNode, metaBeanBuilder);
        } else {
            metaBeanBuilder.addMetaValue(value, bean);
        }
    }

    protected void addBean(Object value, Element beanNode, MetaBeanBuilder metaBeanBuilder) {
        String separator = this.parseUtil.getAttribute(beanNode, "separator");
        String indexFormat = this.parseUtil.getAttribute(beanNode, "index-format");
        String factory = this.parseUtil.getAttribute(beanNode, "factory");
        String methodFactory = this.parseUtil.getAttribute(beanNode, "method-factory");
        String target = this.parseUtil.getAttribute(beanNode, "target");
        Class<?> clazz = null;
        try {
            clazz = Class.forName(target, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        BeanBuilder beanBuilder = metaBeanBuilder.buildMetaValue(value, clazz);
        beanBuilder.setFactory(factory);
        beanBuilder.setMethodfactory(methodFactory);
        beanBuilder.setSeparator(separator);
        beanBuilder.setIndexFormat(indexFormat);
        this.buildBean(beanNode, beanBuilder);
    }

    protected void buildConstructorBean(NodeList consList, BeanBuilder beanBuilder) {
        ConstructorBuilder constructor = beanBuilder.buildConstructor();
        for (int k = 0; k < consList.getLength(); ++k) {
            Element conNode = (Element)consList.item(k);
            String enumPropertyName = this.parseUtil.getAttribute(conNode, "enum-property");
            EnumerationType enumProperty = EnumerationType.valueOf(enumPropertyName);
            String value = this.parseUtil.getAttribute(conNode, "value");
            String temporalProperty = this.parseUtil.getAttribute(conNode, "temporal-property");
            String bean = this.parseUtil.getAttribute(conNode, "bean");
            boolean mapping = Boolean.valueOf(this.parseUtil.getAttribute(conNode, "mapping"));
            String scopeName = this.parseUtil.getAttribute(conNode, "scope");
            ScopeType scope = ScopeType.valueOf(scopeName);
            String factoryName = this.parseUtil.getAttribute(conNode, "type-def");
            String typeName = this.parseUtil.getAttribute(conNode, "type");
            FetchType fetchType = FetchType.valueOf(this.parseUtil.getAttribute(conNode, "fetch-type"));
            Type factory = null;
            boolean nullable = false;
            Class<?> type = null;
            Element anyNode = this.parseUtil.getElement(conNode, "any");
            Element mappingRef = this.parseUtil.getElement(conNode, "ref");
            Element beanNode = this.parseUtil.getElement(conNode, "bean");
            Element valueNode = this.parseUtil.getElement(conNode, "value");
            Element validatorNode = this.parseUtil.getElement(conNode, "validator");
            Element nullNode = this.parseUtil.getElement(conNode, "null");
            if (mappingRef != null) {
                enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(mappingRef, "enum-property"));
                value = this.parseUtil.getAttribute(mappingRef, "value");
                temporalProperty = this.parseUtil.getAttribute(mappingRef, "temporal-property");
                bean = this.parseUtil.getAttribute(mappingRef, "bean");
                mapping = Boolean.valueOf(this.parseUtil.getAttribute(mappingRef, "mapping"));
                scope = ScopeType.valueOf(this.parseUtil.getAttribute(mappingRef, "scope"));
                factoryName = this.parseUtil.getAttribute(mappingRef, "type-def");
                validatorNode = this.parseUtil.getElement(mappingRef, "validator");
            } else {
                if (beanNode != null) {
                    this.addBean(beanNode, beanBuilder, constructor, bean, null, false, null, false, null);
                    continue;
                }
                if (valueNode != null) {
                    value = valueNode.getTextContent();
                } else if (nullNode != null) {
                    nullable = true;
                }
            }
            try {
                if (factoryName != null) {
                    factory = (Type)ClassUtil.getInstance(ClassUtil.get(factoryName));
                }
                if (typeName != null) {
                    type = ClassUtil.get(typeName);
                }
            }
            catch (Exception ex) {
                throw new BrutosException(ex);
            }
            ConstructorArgBuilder constructorBuilder = constructor.addContructorArg(bean, enumProperty, temporalProperty, mapping ? bean : null, scope, value, nullable, anyNode != null, factory, type);
            constructorBuilder.setFetchType(fetchType);
            if (anyNode != null) {
                this.buildAny(anyNode, constructorBuilder);
            }
            this.addValidator(validatorNode, constructorBuilder);
        }
    }

    protected void buildPropertiesBean(NodeList consList, BeanBuilder beanBuilder) {
        for (int k = 0; k < consList.getLength(); ++k) {
            Element propNode = (Element)consList.item(k);
            String propertyName = this.parseUtil.getAttribute(propNode, "name");
            EnumerationType enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(propNode, "enum-property"));
            String value = this.parseUtil.getAttribute(propNode, "value");
            String temporalProperty = this.parseUtil.getAttribute(propNode, "temporal-property");
            String bean = this.parseUtil.getAttribute(propNode, "bean");
            boolean mapping = Boolean.valueOf(this.parseUtil.getAttribute(propNode, "mapping"));
            ScopeType scope = ScopeType.valueOf(this.parseUtil.getAttribute(propNode, "scope"));
            String factoryName = this.parseUtil.getAttribute(propNode, "type-def");
            FetchType fetchType = FetchType.valueOf(this.parseUtil.getAttribute(propNode, "fetch-type"));
            Type factory = null;
            boolean nullable = false;
            Element anyNode = this.parseUtil.getElement(propNode, "any");
            Element mappingRef = this.parseUtil.getElement(propNode, "ref");
            Element beanNode = this.parseUtil.getElement(propNode, "bean");
            Element valueNode = this.parseUtil.getElement(propNode, "value");
            Element validatorNode = this.parseUtil.getElement(propNode, "validator");
            Element nullNode = this.parseUtil.getElement(propNode, "null");
            if (mappingRef != null) {
                enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(mappingRef, "enum-property"));
                value = this.parseUtil.getAttribute(mappingRef, "value");
                temporalProperty = this.parseUtil.getAttribute(mappingRef, "temporal-property");
                bean = this.parseUtil.getAttribute(mappingRef, "bean");
                mapping = Boolean.valueOf(this.parseUtil.getAttribute(mappingRef, "mapping"));
                scope = ScopeType.valueOf(this.parseUtil.getAttribute(mappingRef, "scope"));
                factoryName = this.parseUtil.getAttribute(mappingRef, "type-def");
                validatorNode = this.parseUtil.getElement(mappingRef, "validator");
            } else {
                if (beanNode != null) {
                    this.addBean(beanNode, beanBuilder, null, bean, propertyName, false, null, false, null);
                    continue;
                }
                if (valueNode != null) {
                    value = valueNode.getTextContent();
                } else if (nullNode != null) {
                    nullable = true;
                }
            }
            try {
                if (factoryName != null) {
                    factory = (Type)ClassUtil.getInstance(ClassUtil.get(factoryName));
                }
            }
            catch (Exception ex) {
                throw new BrutosException(ex);
            }
            PropertyBuilder propertyBuilder = beanBuilder.addProperty(bean, propertyName, enumProperty, temporalProperty, mapping ? bean : null, scope, value, nullable, anyNode != null, null, factory);
            propertyBuilder.setFetchType(fetchType);
            if (anyNode != null) {
                this.buildAny(anyNode, propertyBuilder);
            }
            this.addValidator(validatorNode, propertyBuilder);
        }
    }

    protected void addProperties(NodeList properrties, ControllerBuilder controllerBuilder) {
        for (int k = 0; k < properrties.getLength(); ++k) {
            Element propNode = (Element)properrties.item(k);
            this.buildPropertyController(propNode, controllerBuilder);
        }
    }

    protected void buildPropertyController(Element propNode, ControllerBuilder controllerBuilder) {
        String propertyName = this.parseUtil.getAttribute(propNode, "name");
        EnumerationType enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(propNode, "enum-property"));
        String value = this.parseUtil.getAttribute(propNode, "value");
        String temporalProperty = this.parseUtil.getAttribute(propNode, "temporal-property");
        String bean = this.parseUtil.getAttribute(propNode, "bean");
        boolean mapping = Boolean.valueOf(this.parseUtil.getAttribute(propNode, "mapping"));
        ScopeType scope = ScopeType.valueOf(this.parseUtil.getAttribute(propNode, "scope"));
        String factoryName = this.parseUtil.getAttribute(propNode, "type-def");
        FetchType fetchType = FetchType.valueOf(this.parseUtil.getAttribute(propNode, "fetch-type"));
        Type factory = null;
        boolean nullable = false;
        Element anyNode = this.parseUtil.getElement(propNode, "any");
        Element mappingRef = this.parseUtil.getElement(propNode, "ref");
        Element beanNode = this.parseUtil.getElement(propNode, "bean");
        Element valueNode = this.parseUtil.getElement(propNode, "value");
        Element validatorNode = this.parseUtil.getElement(propNode, "validator");
        Element nullNode = this.parseUtil.getElement(propNode, "null");
        if (mappingRef != null) {
            enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(mappingRef, "enum-property"));
            value = this.parseUtil.getAttribute(mappingRef, "value");
            temporalProperty = this.parseUtil.getAttribute(mappingRef, "temporal-property");
            bean = this.parseUtil.getAttribute(mappingRef, "bean");
            mapping = Boolean.valueOf(this.parseUtil.getAttribute(mappingRef, "mapping"));
            scope = ScopeType.valueOf(this.parseUtil.getAttribute(mappingRef, "scope"));
            factoryName = this.parseUtil.getAttribute(mappingRef, "type-def");
            validatorNode = this.parseUtil.getElement(mappingRef, "validator");
        } else {
            if (beanNode != null) {
                this.addBean(beanNode, controllerBuilder, propertyName);
                return;
            }
            if (valueNode != null) {
                value = valueNode.getTextContent();
            } else if (nullNode != null) {
                nullable = true;
            }
        }
        try {
            if (factoryName != null) {
                factory = (Type)ClassUtil.getInstance(ClassUtil.get(factoryName));
            }
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        PropertyBuilder propertyBuilder = controllerBuilder.addProperty(propertyName, bean, scope, enumProperty, temporalProperty, mapping ? bean : null, value, nullable, anyNode != null, null, factory);
        propertyBuilder.setFetchType(fetchType);
        if (anyNode != null) {
            this.buildAny(anyNode, propertyBuilder);
        }
        this.addValidator(validatorNode, propertyBuilder);
    }

    protected void buildKeyCollection(Element conNode, BeanBuilder beanBuilder) {
        String enumPropertyName = this.parseUtil.getAttribute(conNode, "enum-property");
        EnumerationType enumProperty = EnumerationType.valueOf(enumPropertyName);
        String value = this.parseUtil.getAttribute(conNode, "value");
        String temporalProperty = this.parseUtil.getAttribute(conNode, "temporal-property");
        String bean = this.parseUtil.getAttribute(conNode, "bean");
        boolean mapping = Boolean.valueOf(this.parseUtil.getAttribute(conNode, "mapping"));
        String scopeName = this.parseUtil.getAttribute(conNode, "scope");
        ScopeType scope = ScopeType.valueOf(scopeName);
        String factoryName = this.parseUtil.getAttribute(conNode, "type-def");
        String typeName = this.parseUtil.getAttribute(conNode, "type");
        Type factory = null;
        Class<?> type = null;
        Element anyNode = this.parseUtil.getElement(conNode, "any");
        Element mappingRef = this.parseUtil.getElement(conNode, "ref");
        Element beanNode = this.parseUtil.getElement(conNode, "bean");
        Element valueNode = this.parseUtil.getElement(conNode, "value");
        Element validatorNode = this.parseUtil.getElement(conNode, "validator");
        if (mappingRef != null) {
            enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(mappingRef, "enum-property"));
            value = this.parseUtil.getAttribute(mappingRef, "value");
            temporalProperty = this.parseUtil.getAttribute(mappingRef, "temporal-property");
            bean = this.parseUtil.getAttribute(mappingRef, "bean");
            mapping = Boolean.valueOf(this.parseUtil.getAttribute(mappingRef, "mapping"));
            scope = ScopeType.valueOf(this.parseUtil.getAttribute(mappingRef, "scope"));
            factoryName = this.parseUtil.getAttribute(mappingRef, "type-def");
            validatorNode = this.parseUtil.getElement(mappingRef, "validator");
        } else {
            if (beanNode != null) {
                this.addBean(beanNode, beanBuilder, null, null, null, true, bean, false, null);
                return;
            }
            if (valueNode != null) {
                value = valueNode.getTextContent();
            }
        }
        try {
            if (factoryName != null) {
                factory = (Type)ClassUtil.getInstance(ClassUtil.get(factoryName));
            }
            if (typeName != null) {
                type = ClassUtil.get(typeName);
            }
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        KeyBuilder keyBuilder = beanBuilder.setKey(bean, enumProperty, temporalProperty, mapping ? bean : null, scope, value, anyNode != null, factory, type);
        if (anyNode != null) {
            this.buildAny(anyNode, keyBuilder);
        }
        this.addValidator(validatorNode, keyBuilder);
    }

    protected void buildElementCollection(Element conNode, BeanBuilder beanBuilder) {
        String enumPropertyName = this.parseUtil.getAttribute(conNode, "enum-property");
        EnumerationType enumProperty = EnumerationType.valueOf(enumPropertyName);
        String value = this.parseUtil.getAttribute(conNode, "value");
        String temporalProperty = this.parseUtil.getAttribute(conNode, "temporal-property");
        String bean = this.parseUtil.getAttribute(conNode, "bean");
        boolean mapping = Boolean.valueOf(this.parseUtil.getAttribute(conNode, "mapping"));
        String scopeName = this.parseUtil.getAttribute(conNode, "scope");
        ScopeType scope = ScopeType.valueOf(scopeName);
        String factoryName = this.parseUtil.getAttribute(conNode, "type-def");
        String typeName = this.parseUtil.getAttribute(conNode, "type");
        Type factory = null;
        boolean nullable = false;
        Class<?> type = null;
        Element anyNode = this.parseUtil.getElement(conNode, "any");
        Element mappingRef = this.parseUtil.getElement(conNode, "ref");
        Element beanNode = this.parseUtil.getElement(conNode, "bean");
        Element valueNode = this.parseUtil.getElement(conNode, "value");
        Element validatorNode = this.parseUtil.getElement(conNode, "validator");
        Element nullNode = this.parseUtil.getElement(conNode, "null");
        if (mappingRef != null) {
            enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(mappingRef, "enum-property"));
            value = this.parseUtil.getAttribute(mappingRef, "value");
            temporalProperty = this.parseUtil.getAttribute(mappingRef, "temporal-property");
            bean = this.parseUtil.getAttribute(mappingRef, "bean");
            mapping = Boolean.valueOf(this.parseUtil.getAttribute(mappingRef, "mapping"));
            scope = ScopeType.valueOf(this.parseUtil.getAttribute(mappingRef, "scope"));
            factoryName = this.parseUtil.getAttribute(mappingRef, "type-def");
            validatorNode = this.parseUtil.getElement(mappingRef, "validator");
        } else {
            if (beanNode != null) {
                this.addBean(beanNode, beanBuilder, null, null, null, false, null, true, bean);
                return;
            }
            if (valueNode != null) {
                value = valueNode.getTextContent();
            } else if (nullNode != null) {
                nullable = true;
            }
        }
        try {
            if (factoryName != null) {
                factory = (Type)ClassUtil.getInstance(ClassUtil.get(factoryName));
            }
            if (typeName != null) {
                type = ClassUtil.get(typeName);
            }
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        ElementBuilder elementBuilder = beanBuilder.setElement(bean, enumProperty, temporalProperty, mapping ? bean : null, scope, value, nullable, anyNode != null, factory, type);
        if (anyNode != null) {
            this.buildAny(anyNode, elementBuilder);
        }
        this.addValidator(validatorNode, elementBuilder);
    }

    protected void addActions(NodeList actionList, ControllerBuilder controllerBuilder) {
        for (int k = 0; k < actionList.getLength(); ++k) {
            Element actionNodeNode = (Element)actionList.item(k);
            this.addAction(actionNodeNode, controllerBuilder);
        }
    }

    protected void addAction(Element actionNode, ControllerBuilder controllerBuilder) {
        String id = this.parseUtil.getAttribute(actionNode, "id");
        String executor = this.parseUtil.getAttribute(actionNode, "executor");
        String result = this.parseUtil.getAttribute(actionNode, "result");
        String resultRendered = this.parseUtil.getAttribute(actionNode, "result-rendered");
        String view = this.parseUtil.getAttribute(actionNode, "view");
        boolean resolvedView = Boolean.valueOf(this.parseUtil.getAttribute(actionNode, "resolved-view"));
        boolean renderedView = Boolean.valueOf(this.parseUtil.getAttribute(actionNode, "rendered-view"));
        DispatcherType dispatcher = DispatcherType.valueOf(this.parseUtil.getAttribute(actionNode, "dispatcher"));
        ActionBuilder actionBuilder = controllerBuilder.addAction(id, result, Boolean.parseBoolean(resultRendered), renderedView ? view : null, dispatcher, renderedView ? resolvedView : true, executor);
        this.loadActionDependencies(actionNode, actionBuilder);
    }

    protected void loadActionDependencies(Element actionNode, ActionBuilder builder) {
        this.addParametersAction(this.parseUtil.getElements(actionNode, "parameter"), builder);
        this.loadAcceptRequestTypes(this.parseUtil.getElements(actionNode, "accept-request-type"), builder);
        this.loadResponseTypes(this.parseUtil.getElements(actionNode, "response-type"), builder);
        this.addThrowSafe(this.parseUtil.getElements(actionNode, "throw-safe"), builder);
    }

    protected void addParametersAction(NodeList params, ActionBuilder actionBuilder) {
        ParametersBuilder parametersBuilder = actionBuilder.buildParameters();
        for (int k = 0; k < params.getLength(); ++k) {
            Element paramNode = (Element)params.item(k);
            this.addParameterAction(paramNode, parametersBuilder);
        }
    }

    protected void addParameterAction(Element paramNode, ParametersBuilder parametersBuilder) {
        EnumerationType enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(paramNode, "enum-property"));
        String value = this.parseUtil.getAttribute(paramNode, "value");
        String temporalProperty = this.parseUtil.getAttribute(paramNode, "temporal-property");
        String bean = this.parseUtil.getAttribute(paramNode, "bean");
        boolean mapping = Boolean.valueOf(this.parseUtil.getAttribute(paramNode, "mapping"));
        ScopeType scope = ScopeType.valueOf(this.parseUtil.getAttribute(paramNode, "scope"));
        String factoryName = this.parseUtil.getAttribute(paramNode, "type-def");
        String type = this.parseUtil.getAttribute(paramNode, "type");
        FetchType fetchType = FetchType.valueOf(this.parseUtil.getAttribute(paramNode, "fetch-type"));
        Type factory = null;
        Class<?> typeClass = null;
        boolean nullable = false;
        try {
            if (type != null) {
                typeClass = ClassUtil.get(type);
            }
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        Element anyNode = this.parseUtil.getElement(paramNode, "any");
        Element mappingRef = this.parseUtil.getElement(paramNode, "ref");
        Element beanNode = this.parseUtil.getElement(paramNode, "bean");
        Element valueNode = this.parseUtil.getElement(paramNode, "value");
        Element validatorNode = this.parseUtil.getElement(paramNode, "validator");
        Element nullNode = this.parseUtil.getElement(paramNode, "null");
        if (mappingRef != null) {
            enumProperty = EnumerationType.valueOf(this.parseUtil.getAttribute(mappingRef, "enum-property"));
            value = this.parseUtil.getAttribute(mappingRef, "value");
            temporalProperty = this.parseUtil.getAttribute(mappingRef, "temporal-property");
            bean = this.parseUtil.getAttribute(mappingRef, "bean");
            mapping = Boolean.valueOf(this.parseUtil.getAttribute(mappingRef, "mapping"));
            scope = ScopeType.valueOf(this.parseUtil.getAttribute(mappingRef, "scope"));
            factoryName = this.parseUtil.getAttribute(mappingRef, "type-def");
            validatorNode = this.parseUtil.getElement(mappingRef, "validator");
        } else {
            if (beanNode != null) {
                this.addBean(bean, beanNode, parametersBuilder, typeClass);
                return;
            }
            if (valueNode != null) {
                value = valueNode.getTextContent();
            } else if (nullNode != null) {
                nullable = true;
            }
        }
        try {
            if (factoryName != null) {
                factory = (Type)ClassUtil.getInstance(ClassUtil.get(factoryName));
            }
        }
        catch (BrutosException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
        ParameterBuilder parameterBuilder = parametersBuilder.addParameter(bean, scope, enumProperty, temporalProperty, mapping ? bean : null, factory, value, nullable, anyNode != null, typeClass);
        parameterBuilder.setFetchType(fetchType);
        if (anyNode != null) {
            this.buildAny(anyNode, parameterBuilder);
        }
        this.addValidator(validatorNode, parameterBuilder);
    }

    protected void loadAcceptRequestTypes(NodeList nodeList, Object builder) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element c = (Element)nodeList.item(i);
            this.loadAcceptRequestType(c, builder);
        }
    }

    protected void loadAcceptRequestType(Element element, Object builder) {
        String name = StringUtil.adjust(this.parseUtil.getAttribute(element, "name"));
        String text = StringUtil.adjust(element.getTextContent());
        String mediaTypeName = name == null ? text : name;
        DataType dataType = DataType.valueOf(mediaTypeName);
        if (dataType == null) {
            throw new BrutosException("invalid media type: " + mediaTypeName);
        }
        if (builder instanceof ControllerBuilder) {
            ((ControllerBuilder)builder).addRequestType(dataType);
        }
        if (builder instanceof ActionBuilder) {
            ((ActionBuilder)builder).addRequestType(dataType);
        }
    }

    protected void loadResponseTypes(NodeList nodeList, Object builder) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element c = (Element)nodeList.item(i);
            this.loadResponseType(c, builder);
        }
    }

    protected void loadResponseType(Element element, Object builder) {
        String name = StringUtil.adjust(this.parseUtil.getAttribute(element, "name"));
        String text = StringUtil.adjust(element.getTextContent());
        String mediaTypeName = name == null ? text : name;
        DataType dataType = DataType.valueOf(mediaTypeName);
        if (dataType == null) {
            throw new BrutosException("invalid media type: " + mediaTypeName);
        }
        if (builder instanceof ControllerBuilder) {
            ((ControllerBuilder)builder).addResponseType(dataType);
        }
        if (builder instanceof ActionBuilder) {
            ((ActionBuilder)builder).addResponseType(dataType);
        }
    }

    protected void addThrowSafe(NodeList throwSafeNodeList, ControllerBuilder controllerBuilder) {
        for (int i = 0; i < throwSafeNodeList.getLength(); ++i) {
            Element throwSafeNode = (Element)throwSafeNodeList.item(i);
            this.addThrowSafe(throwSafeNode, controllerBuilder);
        }
    }

    protected void addThrowSafe(Element throwSafeNode, ControllerBuilder controllerBuilder) {
        String view = this.parseUtil.getAttribute(throwSafeNode, "view");
        boolean resolvedView = Boolean.valueOf(this.parseUtil.getAttribute(throwSafeNode, "resolved-view"));
        boolean renderedView = Boolean.valueOf(this.parseUtil.getAttribute(throwSafeNode, "rendered-view"));
        String target = this.parseUtil.getAttribute(throwSafeNode, "target");
        String name = this.parseUtil.getAttribute(throwSafeNode, "name");
        DispatcherType dispatcher = DispatcherType.valueOf(this.parseUtil.getAttribute(throwSafeNode, "dispatcher"));
        Class<?> targetClass = this.getClass(target);
        controllerBuilder.addThrowable(targetClass, renderedView ? view : null, name, dispatcher, renderedView ? resolvedView : true);
    }

    protected void addThrowSafe(NodeList throwSafeNodeList, ActionBuilder actionBuilder) {
        for (int i = 0; i < throwSafeNodeList.getLength(); ++i) {
            Element throwSafeNode = (Element)throwSafeNodeList.item(i);
            this.addThrowSafe(throwSafeNode, actionBuilder);
        }
    }

    protected void addThrowSafe(Element throwSafeNode, ActionBuilder actionBuilder) {
        String view = this.parseUtil.getAttribute(throwSafeNode, "view");
        boolean resolvedView = Boolean.valueOf(this.parseUtil.getAttribute(throwSafeNode, "resolved-view"));
        boolean renderedView = Boolean.valueOf(this.parseUtil.getAttribute(throwSafeNode, "rendered-view"));
        String target = this.parseUtil.getAttribute(throwSafeNode, "target");
        String name = this.parseUtil.getAttribute(throwSafeNode, "name");
        DispatcherType dispatcher = DispatcherType.valueOf(this.parseUtil.getAttribute(throwSafeNode, "dispatcher"));
        Class<?> targetClass = this.getClass(target);
        actionBuilder.addThrowable(targetClass, renderedView ? view : null, name, dispatcher, renderedView ? resolvedView : true);
    }

    protected void addValidator(Element validatorNode, RestrictionBuilder restrictionBuilder) {
        if (validatorNode == null) {
            return;
        }
        String msg = this.parseUtil.getAttribute(validatorNode, "message");
        restrictionBuilder.setMessage(msg);
        NodeList rules = this.parseUtil.getElements(validatorNode, "rule");
        for (int i = 0; i < rules.getLength(); ++i) {
            Element rule = (Element)rules.item(i);
            String name = this.parseUtil.getAttribute(rule, "name");
            String value = this.parseUtil.getAttribute(rule, "value");
            value = value == null ? rule.getTextContent() : value;
            RestrictionRules r = RestrictionRules.valueOf(name);
            if (r == null) {
                throw new BrutosException("invalid restriction rule: " + name);
            }
            restrictionBuilder.addRestriction(r, value);
        }
    }

    protected Class<?> getClass(String clazzName) {
        try {
            return clazzName == null ? null : ClassUtil.get(clazzName);
        }
        catch (Exception ex) {
            throw new BrutosException(ex);
        }
    }
}

